-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)  
    
    self.qDoneForest = false
    self.qDoneShallows = false
    
    if not self.loaded then
      self.qDoneFarmers = 0
      self.qDoneSmallTown = 0
      self.qDoneLargeTown = 0
			self.allQuests = 0
    end
    
    self.reinfSmallQ:LinkToTarget("reSmallQ")
    self.reinfLargeQ:LinkToTarget("reLargeQ")
  end
  
  if self.qDoneFarmers == 2 then
    self.p0:WinQuest('D01_FARMS') -- Quest completed msg
    self.p0:AddResource(0,150)
    self.p0:AddResource(6,20)
		self.allQuests = self.allQuests + 1
    self.qDoneFarmers = 0
  end
  
  if self.qDoneForest then
    self.p0:WinQuest('D01_FOREST') -- Quest completed msg
    self.p0:AddResource(1,200)
		self.allQuests = self.allQuests + 1
    self.qDoneForest = false
  end
  
  if self.qDoneShallows then
    self.p0:WinQuest('D01_SHALLOWS') -- Quest completed msg
    self.p0:AddResource(8,300)
		self.allQuests = self.allQuests + 1
    self.qDoneShallows = false
  end
  
  if self.qDoneSmallTown == 3 then
    self.p0:WinQuest('D01_SMALL_TOWN') -- Quest completed msg
    -- deactivate attacks
    self.reinfSmallQ:TriggerAllTargets()
		self.allQuests = self.allQuests + 1
    self.qDoneSmallTown = 0
  end
  
  if self.qDoneLargeTown == 3 then
    self.p0:WinQuest('D01_LARGE_TOWN') -- Quest completed msg
    -- deactivate attacks
    self.reinfLargeQ:TriggerAllTargets()
		self.allQuests = self.allQuests + 1
    self.qDoneLargeTown = 0
  end
  
	if self.allQuests == 5 then
		self.p0:UnlockCharacter("D_Lord-Mordred")
		self.allQuests = 0
	end	
end

function OnTrigger(self, source, target)
  Debug:Log("Source = " .. source .. " !!! Target = " .. target)
  if target == "questFarmers" then
    self.qDoneFarmers = self.qDoneFarmers + 1
  elseif target == "questShallows" then
    self.qDoneShallows = true
  elseif target == "questForest" then
    self.qDoneForest = true
  elseif target == "questSmallTown" then
    self.qDoneSmallTown = self.qDoneSmallTown + 1
  elseif target == "questLargeTown" then
    self.qDoneLargeTown = self.qDoneLargeTown + 1
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.qDoneFarmers = ar:Read()
    self.qDoneSmallTown = ar:Read()
    self.qDoneLargeTown = ar:Read()
		self.allQuests = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.qDoneFarmers)
    ar:Write(self.qDoneSmallTown)
    ar:Write(self.qDoneLargeTown)
		ar:Write(self.allQuests)
  end  
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("questFarmers")
  self:AddTriggerTarget("questShallows")
  self:AddTriggerTarget("questForest")  
  self:AddTriggerTarget("questSmallTown")
  self:AddTriggerTarget("questLargeTown")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("reinfSmallQ")
  self:AddTriggerSource("reinfLargeQ")
end
